/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.servlet.logd.CachedData;
import com.ibm.hwmca.fw.servlet.logd.FileFn;
import com.ibm.hwmca.fw.servlet.logd.LogDisplayerEvent;
import com.ibm.hwmca.fw.servlet.logd.LogServletMsg;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReadNewLogFile {
    private static final String TRACE_MASKT = "XLDSRNLT";
    private static final String TRACE_MASKF = "XLDSRNLF";
    private static final String TRACE_MASKD = "XLDSRNLD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String _getFileNameTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.getfilename.title").toString();

    public ReadNewLogFile() {
        Trace.trace(TRACE_MASKT, "<-> ReadNewLogFile()");
    }

    protected static void readNewLogFile(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKT, "-> GetFileName.getFileName()");
        String fn = request.getParameter("fn");
        if (fn == null || fn.length() == 0) {
            LogServletMsg.displayMsg(request, response, _getFileNameTitle, "XLDSNLFS", MsgType.INFORMATION_MESSAGE);
        } else {
            String fullyQualFn = FileFn.fullyQualify(fn);
            File f = new File(fullyQualFn);
            if (!f.exists() || !f.canRead()) {
                LogServletMsg.displayMsg(request, response, _getFileNameTitle, "XLDSNDES", MsgType.INFORMATION_MESSAGE);
            } else {
                CachedData.clearCachedData();
                if (!fullyQualFn.startsWith("!")) {
                    fullyQualFn = "!" + fullyQualFn;
                }
                LogDisplayerEvent.displayEvents(request, response, "readnewfile", fullyQualFn, null, (short)2192);
            }
        }
        Trace.trace(TRACE_MASKT, "<- GetFileName.getFileName()");
    }
}

